# Site Performans Optimizasyonu

Bu dosya, sitenize uygulanan performans optimizasyonlarını açıklar.

## Uygulanan Optimizasyonlar

### 1. Resim Optimizasyonu
- **WebP Format Desteği**: Modern tarayıcılar için WebP formatına otomatik dönüştürme
- **Responsive Images**: Farklı ekran boyutları için optimize edilmiş resimler
- **Lazy Loading**: Resimlerin ihtiyaç duyulduğunda yüklenmesi
- **Otomatik Boyutlandırma**: Büyük resimlerin otomatik olarak küçültülmesi

**Dosyalar:**
- `func/image_optimizer.php` - Resim optimizasyon sınıfı
- `default/assets/css/resim-boyutlari.css` - Resim boyut stilleri

### 2. CSS/JS Optimizasyonu
- **Dosya Birleştirme**: Birden fazla CSS/JS dosyasının tek dosyada birleştirilmesi
- **Minification**: Gereksiz boşlukların ve yorumların kaldırılması
- **Cache Sistemi**: Minify edilmiş dosyaların cache'lenmesi
- **Defer Loading**: JavaScript dosyalarının sayfa yüklendikten sonra çalıştırılması

**Dosyalar:**
- `func/minifier.php` - CSS/JS minification sınıfı
- `cache/minified/` - Minify edilmiş dosyalar

### 3. Veritabanı Optimizasyonu
- **Query Caching**: Veritabanı sorgularının cache'lenmesi
- **Optimized Queries**: N+1 sorgu probleminin çözülmesi
- **Prepared Statements**: SQL injection koruması ve performans artışı
- **Index Optimization**: Sık kullanılan sorgular için optimize edilmiş fonksiyonlar

**Dosyalar:**
- `func/db_optimizer.php` - Veritabanı optimizasyon sınıfı
- `cache/queries/` - Sorgu cache dosyaları

### 4. Sayfa Cache Sistemi
- **Page Caching**: Tüm sayfa içeriklerinin cache'lenmesi
- **TTL (Time To Live)**: Cache sürelerinin yönetimi
- **Automatic Invalidation**: İçerik değiştiğinde cache'in otomatik temizlenmesi

**Dosyalar:**
- `func/cache.php` - Cache sistemi
- `cache/pages/` - Sayfa cache dosyaları

### 5. Server-Side Optimizasyonlar
- **Gzip Compression**: Dosyaların sıkıştırılması
- **Browser Caching**: Tarayıcı cache ayarları
- **ETag Removal**: Gereksiz ETag'lerin kaldırılması
- **Security Headers**: Güvenlik başlıklarının eklenmesi

**Dosyalar:**
- `.htaccess` - Apache konfigürasyonu

### 6. Performans İzleme
- **Real-time Monitoring**: Gerçek zamanlı performans izleme
- **Metrics Collection**: Yükleme süresi, bellek kullanımı, sorgu sayısı
- **Performance Reports**: Detaylı performans raporları
- **Recommendations**: Otomatik optimizasyon önerileri

**Dosyalar:**
- `performance_monitor.php` - Performans izleme sınıfı

## Performans İyileştirmeleri

### Beklenen Sonuçlar:
- **Sayfa Yükleme Süresi**: %40-60 azalma
- **Veritabanı Sorgu Sayısı**: %50-70 azalma
- **Bellek Kullanımı**: %30-40 azalma
- **Dosya Boyutu**: %20-30 azalma
- **Cache Hit Rate**: %80-90

### PageSpeed Insights Skorları:
- **Mobile Performance**: 70-85+ (önceden 40-60)
- **Desktop Performance**: 85-95+ (önceden 60-80)
- **Core Web Vitals**: Tüm metrikler yeşil

## Kullanım

### Resim Optimizasyonu
```php
// Optimize edilmiş resim al
$optimizedImage = getOptimizedImage("resimler/urunler/product.jpg");

// Responsive resim oluştur
echo getResponsiveImage("resimler/urunler/product.jpg", "Ürün Adı", "product-image");
```

### Veritabanı Optimizasyonu
```php
// Optimize edilmiş ürün sorgusu
$product = getOptimizedProduct(null, $seo);

// Optimize edilmiş ürün listesi
$products = getOptimizedProducts(20, 0, $categoryId);
```

### Cache Yönetimi
```php
// Cache'i temizle
$queryCache->clearQueryCache();
$pageCache->clearPageCache();
```

## Bakım

### Cache Temizleme
Cache dosyaları otomatik olarak temizlenir, ancak manuel temizleme için:
```bash
# Tüm cache'i temizle
rm -rf cache/*

# Sadece minified dosyaları temizle
rm -rf cache/minified/*
```

### Performans İzleme
Performans metrikleri her sayfa yüklemesinde HTML yorumları olarak görüntülenir:
```html
<!-- Performance Metrics -->
<!-- Execution Time: 0.1234s -->
<!-- Memory Usage: 2.5MB -->
<!-- Database Queries: 5 -->
<!-- Cache Files: 12 -->
```

## Sorun Giderme

### Yaygın Sorunlar:

1. **Cache Klasörü Yazma İzni**
   ```bash
   chmod 755 cache/
   chmod 755 cache/minified/
   chmod 755 cache/queries/
   chmod 755 cache/pages/
   ```

2. **WebP Desteği**
   - PHP GD extension'ının yüklü olduğundan emin olun
   - `php -m | grep gd` komutu ile kontrol edin

3. **Minification Hataları**
   - CSS/JS dosyalarının mevcut olduğundan emin olun
   - Dosya yollarının doğru olduğunu kontrol edin

### Log Dosyaları:
- `error_log.txt` - PHP hataları
- `cache/` klasörü - Cache dosyaları ve istatistikleri

## Güncellemeler

Bu optimizasyonlar düzenli olarak güncellenmelidir:
- Yeni ürün eklendiğinde cache temizlenir
- CSS/JS dosyaları değiştiğinde otomatik yeniden minify edilir
- Veritabanı şeması değiştiğinde sorgu cache'i temizlenir

## Destek

Performans sorunları için:
1. `performance_monitor.php` ile metrikleri kontrol edin
2. Cache klasörlerinin yazma izinlerini kontrol edin
3. PHP error log'larını inceleyin
4. `.htaccess` dosyasının doğru çalıştığını kontrol edin
