<?php define("guvenlik", true);
require('../func/db.php');
require('../func/fonksiyon.php');
giriskontrol($ozy, 1);

if (!isset($_SESSION["giris"])) {
    header("Location:index.php");
    exit;
}

$resim_limit = $_SESSION['resim_limit'];
$sayfaidx = temizle($_GET['id']);
$alanx = temizle($_GET['alan']);
$folder_name = '../resimler/genel/';
 
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $tresimler = $ozy->query("SELECT * FROM tumresimler WHERE sayfaid='$sayfaidx' AND alan='$alanx' ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
    $guncel_resim_sayisi = count($tresimler);
    ?>

    <div class="row">
        <div class="col-md-12">
            <p id="resim_limiti" style="color: #30419b; font-weight: 500;">
                Resim Limiti: <?php echo $guncel_resim_sayisi; ?> / <?php echo $resim_limit; ?>
            </p>
        </div>
    </div>
    <br>
    <div class="row">
        <?php foreach ($tresimler as $abc) { ?>
            <div class="col-md-1" style="width:20%;margin-right:-25px;">
                <img src="../resimler/genel/<?php echo $abc['sayfaresim']; ?>" class="img-thumbnail" style="height:75px;width:75px;" />
                <button type="button" class="btn btn-link remove_image" style="background: #30419b; color: #fff; margin-top: 10px; margin-left: 10px; height: 30px; width: 30px; font-size: 12px; padding-left: 8px; font-weight: 500;" id="<?php echo $abc['sayfaresim']; ?>">Sil</button>
            </div>
        <?php } ?>
    </div>

    <script>
        $(document).ready(function () {
            $('#resim_limiti').text('Resim Limiti: <?php echo $guncel_resim_sayisi; ?> / <?php echo $resim_limit; ?>');
        });
    </script>

    <?php
    exit;
}
 
if (isset($_POST["name"])) {
    $resimadimiz = temizle($_POST["name"]);
    $filename = $folder_name . $resimadimiz;
    $tresimsil = $ozy->prepare("DELETE FROM tumresimler WHERE sayfaresim=?");
    $tresimsil->execute([$resimadimiz]);
    if (file_exists($filename)) {
        unlink($filename);
    }
    $ozy->exec("DELETE FROM tumresimler WHERE sayfaid='0'");
    exit;
}
 
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
 
    if (empty($_POST['id']) || empty($_POST['alan'])) {
        http_response_code(400);
        echo "veri_eksik";
        exit;
    }

    if (!isset($_FILES['file']) || $_FILES['file']['error'] !== UPLOAD_ERR_OK) {
        http_response_code(400);
        echo "dosya_hatasi";
        exit;
    }

    $sayfaid = temizle($_POST['id']);
    $alan = temizle($_POST["alan"]);
 
    $mevcut_resimler = $ozy->query("SELECT * FROM tumresimler WHERE sayfaid='$sayfaid' AND alan='$alan'")->fetchAll(PDO::FETCH_ASSOC);
    if (count($mevcut_resimler) >= $resim_limit) {
        http_response_code(400);
        echo "limit_doldu";
        exit;
    }
 
    $tresimkonum = $_FILES['file']['tmp_name'];
    $tresimad = $_FILES['file']['name'];
    $dosya_uzantisi = strtolower(pathinfo($tresimad, PATHINFO_EXTENSION));
    $izin_verilen_uzantilar = ['jpg', 'jpeg', 'png'];

    if (!in_array($dosya_uzantisi, $izin_verilen_uzantilar)) {
        http_response_code(400);
        echo "gecersiz_dosya";
        exit;
    }

    $tyeniad = seo(md5(uniqid(rand()))) . '.' . $dosya_uzantisi;
    $hedef_yol = $folder_name . $tyeniad;

    if (move_uploaded_file($tresimkonum, $hedef_yol)) {
        $tresim = $ozy->prepare("INSERT INTO tumresimler (sayfaid, sayfaresim, alan) VALUES (?, ?, ?)");
        $tresim->execute([$sayfaid, $tyeniad, $alan]);
 
        $sonraki_resimler = $ozy->query("SELECT * FROM tumresimler WHERE sayfaid='$sayfaid' AND alan='$alan'")->fetchAll(PDO::FETCH_ASSOC);
        if (count($sonraki_resimler) > $resim_limit) {
            $ozy->prepare("DELETE FROM tumresimler WHERE sayfaresim=?")->execute([$tyeniad]);
            unlink($hedef_yol);
            http_response_code(400);
            echo "limit_doldu";
            exit;
        }
    } else {
        http_response_code(400);
        echo "yuklenemedi";
        exit;
    }

    exit;
}
?>
